<aside id="sidebar"
    class="w-64 bg-white border-r border-gray-200 fixed md:static inset-y-0 left-0 z-40 overflow-y-auto">
    <!-- Logo -->
    <div class="gradient-gray p-6 text-white">
        <div class="flex items-center justify-between">
            <div>
                <div class="space-y-5">
                    <div class="logo-container flex justify-center">
                        <img src="{{ asset('img/Logo.png') }}" alt="HARRIS Hotel Logo" class="h-20 object-contain">
                    </div>
                </div>
            </div>
            <button onclick="toggleSidebar()" class="md:hidden text-white">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>
    </div>

    <!-- Navigation Menu -->
    <nav class="p-4 space-y-2">
        <!-- Dashboard -->
        <a href="{{ route('admin.dashboard') }}"
            class="sidebar-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
            <i class="fas fa-home w-5"></i>
            <span>Dashboard</span>
        </a>

        <a href="{{ route('admin.user.index') }}"
            class="sidebar-link {{ request()->routeIs('admin.user.index') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
            <i class="fas fa-user w-5"></i>
            <span>User</span>
        </a>

        <a href="{{ route('admin.departemen.index') }}"
            class="sidebar-link {{ request()->routeIs('admin.departemen.index') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
            <i class="fas fa-user w-5"></i>
            <span>Departemen</span>
        </a>
        {{-- <a href="{{ route('admin.user.approval') }}"
            class="sidebar-link {{ request()->routeIs('admin.user.approval') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
            <i class="fas fa-user w-5"></i>
            <span>Konfirmasi Akun</span>
        </a> --}}

        <!-- Manajemen Karyawan -->
        <div class="space-y-1">
            <p class="px-4 text-xs font-semibold text-gray-400 uppercase tracking-wider mt-4 mb-2">Manajemen</p>

            <a href="{{ route('admin.karyawan.index') }}"
                class="sidebar-link {{ request()->routeIs('admin.karyawan.*') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-users w-5"></i>
                <span>Karyawan</span>
            </a>

            <a href="{{ route('admin.jabatan.index') }}"
                class="sidebar-link {{ request()->routeIs('admin.jabatan.*') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-briefcase w-5"></i>
                <span>Jabatan</span>
            </a>
        </div>

        <!-- Absensi & Gaji -->
        <div class="space-y-1">
            <p class="px-4 text-xs font-semibold text-gray-400 uppercase tracking-wider mt-4 mb-2">Data</p>

            <a href="{{ route('admin.absensi.index') }}"
                class="sidebar-link {{ request()->routeIs('admin.absensi.*') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-clock w-5"></i>
                <span>Absensi</span>
            </a>
            <a href="{{ route('admin.cuti') }}"
                class="sidebar-link {{ request()->routeIs('admin.cuti.*') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-clock w-5"></i>
                <span>Cuti</span>
            </a>

            <a href="{{ route('admin.gaji.index') }}"
                class="sidebar-link {{ request()->routeIs('admin.gaji.*') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span>Penggajian</span>
            </a>

            <a href="{{ route('admin.wajah.index') }}"
                class="sidebar-link {{ request()->routeIs('admin.wajah.*') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span>Wajah</span>
            </a>

            <a href="{{ route('admin.shift.index') }}"
                class="sidebar-link {{ request()->routeIs('admin.shift.*') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span>Shift</span>
            </a>

            <a href="{{ route('admin.jadwal-shift.index') }}"
                class="sidebar-link {{ request()->routeIs('admin.jadwal-shift.*') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span>Jadwal Shift</span>
            </a>

            <a href="{{ route('admin.jatah-cuti.index') }}"
                class="sidebar-link {{ request()->routeIs('admin.jatah-cuti.*') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span>Jatah Cuti</span>
            </a>

            <a href="{{ route('admin.activity-log.index') }}"
                class="sidebar-link {{ request()->routeIs('admin.activity-log.*') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-money-bill-wave w-5"></i>
                <span>Log</span>
            </a>

            <!-- Approval (hanya super admin) -->
            @if (auth()->user()->role === 'super_admin')
                <a href="{{ route('admin.approval') }}"
                    class="sidebar-link {{ request()->routeIs('admin.approval') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                    <i class="fas fa-check-double w-5"></i>
                    <span>Approval Pengajuan</span>
                </a>
            @endif

            <!-- Ajukan Shift (untuk admin departemen) -->
            @if (auth()->user()->role === 'admin')
                <a href="{{ route('admin-dept.ajukan-shift.index') }}"
                    class="sidebar-link {{ request()->routeIs('admin-dept.ajukan-shift.*') ? 'active' : '' }} flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                    <i class="fas fa-exchange-alt w-5"></i>
                    <span>Ajukan Shift</span>
                </a>
            @endif
        </div>

        <!-- Laporan -->
        {{-- <div class="space-y-1">
            <p class="px-4 text-xs font-semibold text-gray-400 uppercase tracking-wider mt-4 mb-2">Laporan</p>

            <a href="#" class="sidebar-link flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-chart-line w-5"></i>
                <span>Statistik</span>
            </a>

            <a href="#" class="sidebar-link flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-file-export w-5"></i>
                <span>Export Data</span>
            </a>
        </div> --}}

        <!-- Settings -->
        {{-- <div class="space-y-1">
            <p class="px-4 text-xs font-semibold text-gray-400 uppercase tracking-wider mt-4 mb-2">Sistem</p>

            <a href="#" class="sidebar-link flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-map-marker-alt w-5"></i>
                <span>Lokasi Kantor</span>
            </a>

            <a href="#" class="sidebar-link flex items-center space-x-3 px-4 py-3 text-gray-700 rounded-lg">
                <i class="fas fa-cog w-5"></i>
                <span>Pengaturan</span>
            </a>
        </div> --}}
    </nav>

    <!-- Footer Info -->
    {{-- <div class="absolute bottom-0 left-0 right-0 p-4 border-t border-gray-200 bg-gray-50">
        <div class="text-center">
            <p class="text-xs text-gray-500">© 2025 Harris Hotel</p>
            <p class="text-xs text-gray-400">v1.0.0</p>
        </div>
    </div> --}}
</aside>
